# Satta King API Documentation

## Base URL
```
https://your-domain.com/api/
```

## Authentication
All protected endpoints require JWT Bearer token in Authorization header:
```
Authorization: Bearer <your_jwt_token>
```

Token is received after successful login and valid for 30 days.

---

## 1. Auth API (`auth.php`)

### Login
```
POST /api/auth.php?action=login
Content-Type: application/json

{
    "mobile": "9876543210",
    "password": "yourpassword"
}

Response:
{
    "success": true,
    "data": {
        "token": "eyJhbGci...",
        "user": {
            "id": 1,
            "name": "John Doe",
            "mobile": "9876543210",
            "status": "active",
            "balance": 1500.00,
            "referral_code": "ABC123",
            "has_pin": true,
            "profile_photo": "/uploads/profile_1.jpg"
        },
        "message": "Login successful"
    }
}
```

### Register
```
POST /api/auth.php?action=register
Content-Type: application/json

{
    "name": "John Doe",
    "mobile": "9876543210",
    "password": "yourpassword",
    "referral_code": "XYZ789"  // Optional
}
```

### Check Auth (Validate Token)
```
GET /api/auth.php?action=check
Authorization: Bearer <token>
```

### Refresh Token
```
POST /api/auth.php?action=refresh
Authorization: Bearer <token>
```

---

## 2. Games API (`games.php`)

### Get All Games
```
GET /api/games.php?action=list

Response:
{
    "success": true,
    "data": {
        "games": [
            {
                "id": 1,
                "name": "Desawar",
                "open_time": "05:00:00",
                "close_time": "03:00:00",
                "is_overnight": true,
                "is_open": true,
                "playing_date": "2024-01-15",
                "today_result": "45",
                "status_text": "OPEN"
            }
        ],
        "balance": 1500.00  // If authenticated
    }
}
```

### Get Game Detail
```
GET /api/games.php?action=detail&id=1
```

### Get Game Results History
```
GET /api/games.php?action=results&id=1&limit=30&page=1
```

### Get Today's All Results
```
GET /api/games.php?action=today_results&date=2024-01-15
```

### Get Game Rates
```
GET /api/games.php?action=rates
```

---

## 3. Bids API (`bids.php`)

### Place Bid(s)
```
POST /api/bids.php?action=place
Authorization: Bearer <token>
Content-Type: application/json

{
    "game_id": 1,
    "bids": [
        {"type": "jodi", "number": "45", "amount": 100},
        {"type": "andar", "number": "4", "amount": 50},
        {"type": "bahar", "number": "5", "amount": 50}
    ]
}

Response:
{
    "success": true,
    "data": {
        "message": "3 bid(s) placed successfully!",
        "bids": [
            {
                "bid_id": 123,
                "type": "jodi",
                "number": "45",
                "amount": 100,
                "potential_win": 9500
            }
        ],
        "total_amount": 200,
        "new_balance": 1300.00
    }
}
```

### Get Bid History
```
GET /api/bids.php?action=history&status=pending&limit=50&page=1
Authorization: Bearer <token>

Status options: pending, won, lost, cancelled
```

### Get Today's Bids
```
GET /api/bids.php?action=today
Authorization: Bearer <token>
```

### Cancel Bid
```
POST /api/bids.php?action=cancel
Authorization: Bearer <token>
Content-Type: application/json

{
    "bid_id": 123
}
```

---

## 4. Wallet API (`wallet.php`)

### Get Balance & Stats
```
GET /api/wallet.php?action=balance
Authorization: Bearer <token>
```

### Deposit Request
```
POST /api/wallet.php?action=deposit
Authorization: Bearer <token>
Content-Type: multipart/form-data

amount: 1000
screenshot: <file>
```

### Withdraw Request
```
POST /api/wallet.php?action=withdraw
Authorization: Bearer <token>
Content-Type: application/json

{
    "amount": 500,
    "pin": "1234"  // If PIN is enabled
}
```

### Get Transaction History
```
GET /api/wallet.php?action=history&type=credit&limit=50&page=1
Authorization: Bearer <token>

Type options: credit, debit (or empty for all)
```

### Get Wallet Requests
```
GET /api/wallet.php?action=requests&type=deposit&status=pending
Authorization: Bearer <token>
```

### Set Transaction PIN
```
POST /api/wallet.php?action=set_pin
Authorization: Bearer <token>
Content-Type: application/json

{
    "pin": "1234",
    "current_pin": "0000"  // Only if changing existing PIN
}
```

### Verify PIN
```
POST /api/wallet.php?action=verify_pin
Authorization: Bearer <token>
Content-Type: application/json

{
    "pin": "1234"
}
```

---

## 5. Profile API (`profile.php`)

### Get Profile
```
GET /api/profile.php?action=get
Authorization: Bearer <token>
```

### Update Profile
```
POST /api/profile.php?action=update
Authorization: Bearer <token>
Content-Type: application/json

{
    "name": "John Doe",
    "bank_name": "SBI",
    "account_no": "1234567890",
    "account_holder": "John Doe",
    "ifsc_code": "SBIN0001234",
    "upi_id": "john@upi"
}
```

### Change Password
```
POST /api/profile.php?action=change_password
Authorization: Bearer <token>
Content-Type: application/json

{
    "current_password": "oldpass",
    "new_password": "newpass"
}
```

### Upload Profile Photo
```
POST /api/profile.php?action=upload_photo
Authorization: Bearer <token>
Content-Type: multipart/form-data

photo: <file>
```

### Get User Stats
```
GET /api/profile.php?action=stats
Authorization: Bearer <token>
```

---

## 6. Notifications API (`notifications.php`)

### Get Notifications
```
GET /api/notifications.php?action=list&unread=1&limit=50&page=1
Authorization: Bearer <token>
```

### Mark as Read
```
POST /api/notifications.php?action=mark_read
Authorization: Bearer <token>
Content-Type: application/json

{
    "notification_id": 123
}
// OR for all:
{
    "all": true
}
```

### Get Unread Count
```
GET /api/notifications.php?action=unread_count
Authorization: Bearer <token>
```

---

## 7. Referral API (`referral.php`)

### Get Referral Stats
```
GET /api/referral.php?action=stats
Authorization: Bearer <token>
```

### Get Referral List
```
GET /api/referral.php?action=list&limit=50&page=1
Authorization: Bearer <token>
```

### Validate Referral Code (Public)
```
GET /api/referral.php?action=validate&code=ABC123
```

### Get Share Text
```
GET /api/referral.php?action=share_text
Authorization: Bearer <token>
```

---

## 8. Settings API (`settings.php`)

### Get App Config (Public)
```
GET /api/settings.php?action=app_config
```

### Get Payment Info
```
GET /api/settings.php?action=payment_info
```

### Get Contact Info
```
GET /api/settings.php?action=contact
```

### Get Game Rules
```
GET /api/settings.php?action=rules
```

---

## Error Responses

```json
{
    "success": false,
    "message": "Error message here",
    "errors": {
        "code": "ERROR_CODE"
    }
}
```

### Common Error Codes:
- `401` - Unauthorized (invalid/expired token)
- `400` - Bad Request (validation error)
- `403` - Forbidden (account locked/blocked)
- `404` - Not Found
- `429` - Too Many Requests (rate limited)
- `500` - Server Error

### Special Error Codes in Response:
- `PIN_NOT_SET` - Transaction PIN not set
- `PIN_REQUIRED` - PIN required for this action
- `INVALID_PIN` - Wrong PIN entered
- `BANK_DETAILS_REQUIRED` - Bank details not set

---

## Rate Limits
- Login: 10 attempts per 5 minutes
- Bids: 50 per minute
- Deposits: 5 per hour
- Withdrawals: 3 per hour
- General API: 60 requests per minute

---

## Notes for Android App

1. Store JWT token securely (EncryptedSharedPreferences)
2. Include token in all authenticated requests
3. Handle 401 errors by redirecting to login
4. Handle `PIN_NOT_SET` by showing PIN setup dialog
5. Refresh token before it expires
6. Handle offline mode gracefully
