<?php
require_once 'config/db.php';
require_once 'config/auth.php';
require_once 'config/functions.php';
require_once 'config/security.php';

initSecureSession();
requireLogin();

if (!checkSessionTimeout($pdo)) {
    header("Location: login.php?msg=Session+expired");
    exit();
}

$user = getUser($pdo);
if (!$user) {
    session_destroy();
    header("Location: login.php");
    exit();
}

trackUserSession($pdo, $user['id']);

$balance = getWalletBalance($pdo, $user['id']);

$stmt = $pdo->query("SELECT * FROM games WHERE status = 'active' ORDER BY sort_order ASC, name ASC");
$games = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Satta King - Play Online</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #0f0f0f;
            color: #fff;
            min-height: 100vh;
            padding-bottom: 80px;
        }
        
        /* Header */
        .header {
            background: linear-gradient(135deg, #8b0000 0%, #1a1a1a 100%);
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 15px rgba(0,0,0,0.5);
        }
        
        .logo {
            font-size: 20px;
            font-weight: 800;
            color: #ffd700;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
        }
        
        .wallet-btn {
            background: linear-gradient(135deg, #ffd700 0%, #ff8c00 100%);
            color: #000;
            padding: 10px 20px;
            border-radius: 25px;
            font-weight: 700;
            font-size: 14px;
            text-decoration: none;
            box-shadow: 0 4px 15px rgba(255,215,0,0.3);
        }
        
        /* Main Content */
        .container {
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Welcome Card */
        .welcome-card {
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 25px;
            border: 1px solid #333;
        }
        
        .welcome-card p {
            color: #888;
            font-size: 14px;
        }
        
        .welcome-card .name {
            color: #ffd700;
            font-weight: 600;
        }
        
        .balance-display {
            margin-top: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .balance-label {
            color: #888;
            font-size: 12px;
        }
        
        .balance-amount {
            font-size: 28px;
            font-weight: 700;
            color: #00ff88;
        }
        
        /* Section Title */
        .section-title {
            color: #ffd700;
            font-size: 18px;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #333;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        /* Games Grid */
        .games-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 15px;
        }
        
        /* Game Card */
        .game-card {
            background: linear-gradient(145deg, #1e1e1e 0%, #2a2a2a 100%);
            border-radius: 16px;
            overflow: hidden;
            border: 1px solid #333;
            transition: all 0.3s ease;
        }
        
        .game-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(255,215,0,0.1);
            border-color: #ffd700;
        }
        
        .game-card.overnight {
            border-left: 4px solid #ffd700;
        }
        
        .game-header {
            background: linear-gradient(135deg, #8b0000 0%, #5c0000 100%);
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .game-name {
            font-size: 18px;
            font-weight: 700;
            color: #fff;
        }
        
        .overnight-badge {
            background: rgba(255,215,0,0.2);
            color: #ffd700;
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 600;
        }
        
        .game-body {
            padding: 20px;
        }
        
        .game-stats {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            margin-bottom: 20px;
        }
        
        .stat-box {
            background: #1a1a1a;
            padding: 12px 8px;
            border-radius: 10px;
            text-align: center;
        }
        
        .stat-label {
            font-size: 10px;
            color: #666;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .stat-value {
            font-size: 14px;
            font-weight: 600;
            color: #fff;
            margin-top: 4px;
        }
        
        .game-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-top: 15px;
            border-top: 1px solid #333;
        }
        
        .result-box {
            text-align: left;
        }
        
        .result-label {
            font-size: 11px;
            color: #666;
        }
        
        .result-number {
            font-size: 32px;
            font-weight: 800;
            color: #00ff88;
            line-height: 1;
        }
        
        .result-waiting {
            font-size: 32px;
            font-weight: 800;
            color: #444;
            line-height: 1;
        }
        
        .result-date {
            font-size: 10px;
            color: #666;
        }
        
        /* Buttons */
        .btn-play {
            background: linear-gradient(135deg, #00c853 0%, #00a844 100%);
            color: #fff;
            padding: 12px 30px;
            border-radius: 25px;
            font-weight: 700;
            font-size: 14px;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 4px 15px rgba(0,200,83,0.3);
            transition: all 0.3s ease;
        }
        
        .btn-play:hover {
            transform: scale(1.05);
            box-shadow: 0 6px 20px rgba(0,200,83,0.4);
        }
        
        .btn-closed {
            background: #333;
            color: #666;
            padding: 12px 25px;
            border-radius: 25px;
            font-weight: 600;
            font-size: 13px;
            cursor: not-allowed;
        }
        
        .btn-pending {
            background: linear-gradient(135deg, #ff9800 0%, #f57c00 100%);
            color: #fff;
            padding: 12px 20px;
            border-radius: 25px;
            font-weight: 600;
            font-size: 12px;
            cursor: not-allowed;
        }
        
        .btn-holiday {
            background: linear-gradient(135deg, #e91e63 0%, #c2185b 100%);
            color: #fff;
            padding: 12px 20px;
            border-radius: 25px;
            font-weight: 600;
            font-size: 12px;
            cursor: not-allowed;
        }
        
        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #666;
        }
        
        .empty-state .icon {
            font-size: 60px;
            margin-bottom: 15px;
        }
        
        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: #1a1a1a;
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            border-top: 1px solid #333;
            z-index: 100;
        }
        
        .nav-item {
            text-align: center;
            color: #666;
            text-decoration: none;
            padding: 5px 15px;
            transition: all 0.3s ease;
        }
        
        .nav-item.active {
            color: #ffd700;
        }
        
        .nav-icon {
            font-size: 22px;
            display: block;
            margin-bottom: 4px;
        }
        
        .nav-label {
            font-size: 10px;
            font-weight: 500;
        }
        
        /* Responsive */
        @media (max-width: 400px) {
            .header {
                padding: 12px 15px;
            }
            .logo {
                font-size: 18px;
            }
            .wallet-btn {
                padding: 8px 15px;
                font-size: 13px;
            }
            .game-stats {
                grid-template-columns: repeat(3, 1fr);
                gap: 8px;
            }
            .stat-box {
                padding: 10px 5px;
            }
            .result-number, .result-waiting {
                font-size: 28px;
            }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="logo">🎰 SATTA KING</div>
        <a href="wallet.php" class="wallet-btn">₹<?= number_format($balance, 2) ?></a>
    </header>

    <div class="container">
        <!-- Welcome Card -->
        <div class="welcome-card">
            <p>Welcome back, <span class="name"><?= htmlspecialchars($user['name']) ?></span>! 🎲</p>
            <div class="balance-display">
                <div>
                    <div class="balance-label">Your Balance</div>
                    <div class="balance-amount">₹<?= number_format($balance, 2) ?></div>
                </div>
                <a href="wallet.php" class="btn-play" style="padding: 10px 20px; font-size: 13px;">+ Add Money</a>
            </div>
        </div>

        <h2 class="section-title">🎯 Live Games</h2>

        <?php if (empty($games)): ?>
            <div class="empty-state">
                <div class="icon">🎮</div>
                <p>No games available right now</p>
            </div>
        <?php else: ?>
            <div class="games-grid">
                <?php foreach ($games as $game): 
                    $isOpen = isGameOpen($pdo, $game);
                    $statusText = getGameStatusText($pdo, $game);
                    $playingDate = getGamePlayingDate($game);
                    
                    // Today's result
                    $stmt = $pdo->prepare("SELECT * FROM results WHERE game_id = ? AND playing_date = ?");
                    $stmt->execute([$game['id'], $playingDate]);
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                    
                    // Last result if no today result
                    $lastResult = null;
                    if (!$result) {
                        $stmt = $pdo->prepare("SELECT * FROM results WHERE game_id = ? ORDER BY playing_date DESC LIMIT 1");
                        $stmt->execute([$game['id']]);
                        $lastResult = $stmt->fetch(PDO::FETCH_ASSOC);
                    }
                ?>
                    <div class="game-card <?= $game['is_overnight'] ? 'overnight' : '' ?>">
                        <div class="game-header">
                            <div class="game-name"><?= htmlspecialchars($game['name']) ?></div>
                            <?php if ($game['is_overnight']): ?>
                                <span class="overnight-badge">🌙 Overnight</span>
                            <?php endif; ?>
                        </div>
                        
                        <div class="game-body">
                            <div class="game-stats">
                                <div class="stat-box">
                                    <div class="stat-label">Open</div>
                                    <div class="stat-value"><?= date('h:i A', strtotime($game['open_time'])) ?></div>
                                </div>
                                <div class="stat-box">
                                    <div class="stat-label">Close</div>
                                    <div class="stat-value"><?= date('h:i A', strtotime($game['close_time'])) ?></div>
                                </div>
                                <div class="stat-box">
                                    <div class="stat-label">Rate</div>
                                    <div class="stat-value" style="color: #ffd700;"><?= $game['rate'] ?>x</div>
                                </div>
                            </div>

                            <div class="game-footer">
                                <div class="result-box">
                                    <div class="result-label">Last Result</div>
                                    <?php if ($result): ?>
                                        <div class="result-number"><?= htmlspecialchars($result['result']) ?></div>
                                        <div class="result-date">Today</div>
                                    <?php elseif ($lastResult): ?>
                                        <div class="result-number"><?= htmlspecialchars($lastResult['result']) ?></div>
                                        <div class="result-date"><?= date('d M', strtotime($lastResult['playing_date'])) ?></div>
                                    <?php else: ?>
                                        <div class="result-waiting">--</div>
                                        <div class="result-date">No result yet</div>
                                    <?php endif; ?>
                                </div>
                                
                                <?php if ($isOpen): ?>
                                    <a href="play.php?id=<?= $game['id'] ?>" class="btn-play">▶ PLAY</a>
                                <?php elseif ($statusText == 'Result Pending'): ?>
                                    <span class="btn-pending">⏳ RESULT PENDING</span>
                                <?php elseif ($statusText == 'Holiday'): ?>
                                    <span class="btn-holiday">🏖️ HOLIDAY</span>
                                <?php else: ?>
                                    <span class="btn-closed">⏰ CLOSED</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <nav class="bottom-nav">
        <a href="index.php" class="nav-item active">
            <span class="nav-icon">🏠</span>
            <span class="nav-label">Home</span>
        </a>
        <a href="wallet.php" class="nav-item">
            <span class="nav-icon">💰</span>
            <span class="nav-label">Wallet</span>
        </a>
        <a href="history.php" class="nav-item">
            <span class="nav-icon">📋</span>
            <span class="nav-label">History</span>
        </a>
        <a href="profile.php" class="nav-item">
            <span class="nav-icon">👤</span>
            <span class="nav-label">Profile</span>
        </a>
    </nav>
</body>
</html>
